/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.screen;

import com.iafenvoy.jupiter.config.container.wrapper.RemoteConfigWrapper;
import com.iafenvoy.jupiter.config.entry.BaseEntry;
import com.iafenvoy.jupiter.config.interfaces.ConfigEntry;
import com.iafenvoy.jupiter.config.interfaces.ConfigMetaProvider;
import com.iafenvoy.jupiter.render.TitleStack;
import com.iafenvoy.jupiter.render.screen.JupiterScreen;
import com.iafenvoy.jupiter.render.screen.WidgetBuilderManager;
import com.iafenvoy.jupiter.render.screen.scrollbar.VerticalScrollBar;
import com.iafenvoy.jupiter.render.widget.WidgetBuilder;
import com.iafenvoy.jupiter.util.TextUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigListScreen
extends class_437
implements JupiterScreen {
    private final class_437 parent;
    private final TitleStack titleStack;
    private final class_2960 id;
    private final boolean client;
    protected final List<WidgetBuilder<?>> configWidgets = new ArrayList();
    protected final VerticalScrollBar entryScrollBar = new VerticalScrollBar();
    protected List<ConfigEntry<?>> entries = List.of();
    protected int topBorder = 30;
    private int configPerPage;
    private int textMaxLength;

    public ConfigListScreen(class_437 parent, TitleStack titleStack, class_2960 id, List<ConfigEntry<?>> entries, boolean client) {
        this(parent, titleStack, id, client);
        this.entries = entries;
    }

    public ConfigListScreen(class_437 parent, TitleStack titleStack, class_2960 id, boolean client) {
        super((class_2561)TextUtil.empty());
        this.parent = parent;
        this.titleStack = titleStack;
        this.id = id;
        this.client = client;
    }

    protected void method_25426() {
        super.method_25426();
        this.titleStack.cacheTitle(this.field_22789 - this.field_22793.method_1727(this.getCurrentEditText()) - 70);
        this.method_37063((class_364)JupiterScreen.createButton(10, 5, 20, 20, (class_2561)TextUtil.literal("<"), button -> this.method_25419()));
        this.calculateMaxEntries();
        this.textMaxLength = class_3532.method_15340((int)(this.entries.stream().filter(x -> x instanceof BaseEntry).map(ConfigEntry::getName).filter(Objects::nonNull).map(t -> this.field_22793.method_27525((class_5348)t)).max(Comparator.naturalOrder()).orElse(0) + 30), (int)(this.field_22789 / 2), (int)(this.field_22789 - 150));
        this.configWidgets.clear();
        this.configWidgets.addAll(this.entries.stream().map(c -> WidgetBuilderManager.get(new ConfigMetaProvider.SimpleProvider(this.id, "%ERROR%", this.client), c)).toList());
        this.configWidgets.forEach(b -> b.addElements(new WidgetBuilder.Context(this, x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        }, this.titleStack), this.textMaxLength, 0, Math.max(10, this.field_22789 - this.textMaxLength - 30), 20));
        this.updateEntryPos();
    }

    public void method_25410(@NotNull class_310 minecraft, int width, int height) {
        super.method_25410(minecraft, width, height);
        this.calculateMaxEntries();
        this.updateEntryPos();
    }

    @NotNull
    public class_2561 method_25440() {
        return this.titleStack.getTitle();
    }

    public void calculateMaxEntries() {
        this.configPerPage = Math.max(0, (this.field_22790 - this.topBorder - 10) / 25);
        this.entryScrollBar.setMaxValue(Math.max(0, this.entries.size() - this.configPerPage));
    }

    public void updateEntryPos() {
        int i;
        int top = this.entryScrollBar.getValue();
        for (i = 0; i < top && i < this.entries.size(); ++i) {
            this.configWidgets.get(i).update(false, 0);
        }
        for (i = top; i < top + this.configPerPage && i < this.entries.size(); ++i) {
            this.configWidgets.get(i).update(true, this.topBorder + 5 + (i - top) * 25);
        }
        for (i = top + this.configPerPage; i < this.entries.size(); ++i) {
            this.configWidgets.get(i).update(false, 0);
        }
    }

    @Nullable
    public ConfigEntry<?> getMouseOverEntry(int mouseX, int mouseY) {
        return this.configWidgets.stream().filter(widget -> widget.isMouseOver(mouseX, mouseY)).findFirst().map(WidgetBuilder::getConfig).orElse(null);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollY) {
        if (super.method_25401(mouseX, mouseY, scrollY)) {
            return true;
        }
        if (mouseY >= (double)this.topBorder) {
            this.entryScrollBar.setValue(this.entryScrollBar.getValue() + (scrollY > 0.0 ? -1 : 1) * 2);
            this.updateEntryPos();
            return true;
        }
        return false;
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        ConfigEntry<?> entry;
        this.method_25420(graphics);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        String currentText = this.getCurrentEditText();
        int textWidth = this.field_22793.method_1727(currentText);
        graphics.method_51439(this.field_22793, this.method_25440(), 40, 10, -1, true);
        graphics.method_25303(this.field_22793, currentText, this.field_22789 - textWidth - 10, 10, -1);
        this.entryScrollBar.render(graphics, mouseX, mouseY, partialTicks, this.field_22789 - 18, this.topBorder, 8, this.field_22790 - this.topBorder - 10, (this.configPerPage + this.entryScrollBar.getMaxValue()) * 25);
        if (this.entryScrollBar.isDragging()) {
            this.updateEntryPos();
        }
        if ((entry = this.getMouseOverEntry(mouseX, mouseY)) != null && entry.getTooltip() != null) {
            this.method_47415(entry.getTooltip());
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.entryScrollBar.wasMouseOver()) {
            this.entryScrollBar.setIsDragging(true);
            this.updateEntryPos();
            return true;
        }
        boolean b = super.method_25402(mouseX, mouseY, button);
        if (!b) {
            this.method_25395(null);
        }
        return b;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.entryScrollBar.setIsDragging(false);
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    protected String getCurrentEditText() {
        if (this.client) {
            return class_1074.method_4662((String)"jupiter.screen.current_modifying_client", (Object[])new Object[0]);
        }
        if (this.entries instanceof RemoteConfigWrapper) {
            return class_1074.method_4662((String)"jupiter.screen.current_modifying_dedicate_server", (Object[])new Object[0]);
        }
        return class_1074.method_4662((String)"jupiter.screen.current_modifying_local_server", (Object[])new Object[0]);
    }
}

